﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using System.Data;
using System.Data.SqlClient;
using ExampleApi.models;

namespace ExampleApi.Controllers
{
    [Route("api/[controller]")]
    [ApiController]
    public class TestController : ControllerBase
    {
        private readonly string _connectionString;
        public TestController(IConfiguration configuration)
        {
            // Connection string را از appsettings.json دریافت می‌کنیم
            _connectionString = configuration.GetConnectionString("DefaultConnection");
        }

        // GET: api/Payslips/employee/100029?year=1401&month=1
        [HttpGet("employee")]
        public async Task<ActionResult<PayslipDetailDto>> GetEmployeePayslip([FromQuery] string employeeId, int year, int month)
        {
            PayslipDetailDto payslipData = null;
            // کوئری SQL با JOIN برای دریافت نام کارمند و جزئیات فیش حقوقی
            // فرض می‌کنیم نام ستون‌ها در جدول Employees شامل FirstName و LastName است
            string query = @"

                            SELECT  DISTINCT l.LEVFOUR_CON'کد تفصیل',lf.NAME'نام پرسنل',p.PersonalCode'کد پرسنلی',L.FY,L.MOUNTH,L.NewOrdinance_CON
                            ,cast(p.NationalId as varchar)' کد ملی '
                            ,cast(p.EmissionPlace as varchar)'محل صدور'
                            ,p.BirthDate' تاریخ تولد '
                            ,cast(p.BirthPlace as varchar)' محل تولد '
                            ,cast(p.FatherName as varchar)' نام پدر '
                            ,case p.Gender when '1' then 'مرد' when '0' then 'زن' end' جنسیت '
                            ,cast(p.InsuranceNumber as varchar)' شماره بیمه '
                            ,cast(p.Nationality as varchar)' ملیت '
                            ,p.shomarehesab 'شماره حساب'
                            ,case l.mounth when 1 then 'فروردین' when 2 then 'اردیبهشت' when 3 then 'خرداد' when 4 then 'تیر' when 5 then 'مرداد' when 6 then 'شهریور' when 7 then 'مهر' when 8 then 'آبان' when 9 then 'آذر' when 10 then 'دی' when 11 then 'بهمن' when 12 then 'اسفند' end 'ماه شمسی'  
                            ,n.OrdinanceEmissionDate' تاریخ حکم ',cast(n.OrdinanceNumber as varchar)' شماره حکم ',n.EmployeeDate'تاریخ استخدام'
                            ,cast(i.dayofkarkard as varchar)'روزهای کارکرد'
                            ,cast(i.timeofezafeh as varchar)+':'+cast(i.minezafe as varchar)' ساعت اضافه کاری '
                            ,cast(i.timeoftatil as varchar)+':'+cast(i.mintatil as varchar)'ساعت تعطیل کاری' 
                            ,cast(i.timeofkasr as varchar)+':'+cast(i.minkasr as varchar)'ساعت کسر کار' 
                            ,CAST(i.dayofduty as varchar)'تعداد روز ماموریت'
                            ,cast(i.timeofkarkard as varchar)+':'+cast(i.minkarkard as varchar)'ساعت کارکرد پرسنل ساعتی'
                            ,cast(i.dayofayabozahab as varchar)'تعداد روز ایاب و ذهاب',cast(i.timeofabsent as varchar)'تعداد روز غیبت'
                            ,cast(i.tedad_roz_moavagheh as varchar)' تعداد روز معوقه '
                            ,cast(i.timeofshabkari as varchar)+':'+cast(i.mineshabkari as varchar)'ساعت شبکاری'
                            ,CASE n.typehoghogh WHEN 1 THEN ' حقوق ثابت ' WHEN 2 THEN ' حقوق روزانه ' WHEN 3 THEN ' حقوق ساعتی ' end' نوع حکم' 

                            ,'مرخصی'=(select sum(vo.Day) from PAY.RequestVacation vo where PersonalInfo_con=p.PersonalID and Type=1 and fy=L.FY and mounth=L.MOUNTH)
                            ,'مانده مرخصی'=(select top 1 v.Remain from PAY.RequestVacation v where PersonalInfo_con=p.PersonalID and Type=1 and fy=L.FY order by fromDate desc)
                            --,'مقدار مرخصی ساعتی ماه جاری'=(select sum(vo.Time) from PAY.RequestVacation vo where PersonalInfo_con=p.PersonalID and Type=1 and fy=L.FY and mounth=L.MOUNTH)

                            ,'مبلغ کل بازپرداختی وام'=(select SUM(amountpay) from PAY.RestoreLoan where PayLoan_con in (select PayLoanid from PAY.PersonalInfo o right join PAY.PayLoan pl on pl.PersonalInfo_con=o.PersonalID where o.PersonalID=p.PersonalID)) 
                            ,'کل مبلغ وام'=(select sum(AmountLoan) from PAY.PersonalInfo o right join PAY.PayLoan pl on pl.PersonalInfo_con=o.PersonalID where o.PersonalID=p.PersonalID)  
                            ,'مانده وام'=(select sum(AmountLoan) from PAY.PersonalInfo o right join PAY.PayLoan pl on pl.PersonalInfo_con=o.PersonalID where o.PersonalID=p.PersonalID)
                            -(select isnull(SUM(amountpay),0) from PAY.RestoreLoan where PayLoan_con in (select PayLoanid from PAY.PersonalInfo o 
                            right join PAY.PayLoan pl on pl.PersonalInfo_con=o.PersonalID where o.PersonalID=p.PersonalID))
                            ,'عیدی ماهیانه'=(select amount from pay.Eydi_monthly em where em.fy=L.FY and em.month=L.MOUNTH and em.Levfour_con=i.levfoure_con) 
                            ,'سنوات خدمت ماهیانه'=(select amount from pay.sanavat_monthly sm where sm.fy=L.FY and sm.month=L.MOUNTH and sm.Levfour_con=i.levfoure_con) 
                            ,n.EmployeeType_con
                            ,'P1'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=1 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH) 
                            ,'P2'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=2 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P3'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=3 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P4'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=4 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P5'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=5 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P6'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=6 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P7'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=7 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P8'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=8 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P9'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=9 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P10'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=10 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)



                            ,'P11'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=11 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P12'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=12 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P13'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=13 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P14'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=14 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P15'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=15 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P16'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=16 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P17'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=17 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P18'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=18 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P19'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=19 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P20'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=20 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)

                            ,'P21'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=21 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P22'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=22 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P23'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=23 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P24'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=24 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P25'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=25 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P26'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=26 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P27'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=27 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P28'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=28 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P29'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=29 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P30'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=30 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)

                            ,'P31'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=31 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P32'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=32 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P33'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=33 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P34'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=34 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P35'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=35 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P36'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=36 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P37'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=37 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P38'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=38 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P39'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=39 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P40'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=40 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)

                            ,'P41'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=41 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P42'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=42 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P43'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=43 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P44'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=44 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P45'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=45 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P46'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=46 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P47'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=47 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P48'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=48 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P49'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=49 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P50'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=50 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)

                            ,'P51'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=51 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P52'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=52 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P53'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=53 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P54'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=54 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P55'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=55 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P56'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=56 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P57'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=57 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P58'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=58 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P59'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=59 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P60'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=60 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)

                            ,'P61'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=61 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P62'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=62 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P63'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=63 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P64'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=64 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P65'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=65 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P66'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=66 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P67'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=67 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P68'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=68 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P69'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=69 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P70'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=70 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)

                            ,'P99'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=99 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P100'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=100 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P101'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=101 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)

                            ,'P201'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=201 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P202'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=202 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P203'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=203 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P204'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=204 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P205'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=205 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P206'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=206 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P207'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=207 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P208'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=208 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P209'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=209 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P210'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=210 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)

                            ,'P211'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=211 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P212'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=212 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P213'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=213 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P214'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=214 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P215'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=215 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P216'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=216 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P217'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=217 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P218'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=218 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P219'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=219 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P220'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=220 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)

                            ,'P221'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=221 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P222'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=222 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P223'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=223 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P224'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=224 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P225'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=225 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P226'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=226 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P227'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=227 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P228'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=228 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P229'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=229 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P230'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=230 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)

                            ,'P231'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=231 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P232'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=232 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P233'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=233 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P234'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=234 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P235'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=235 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P236'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=236 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P237'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=237 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P238'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=238 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P239'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=239 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P240'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=240 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)

                            ,'P241'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=241 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P242'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=242 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P243'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=243 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P244'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=244 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P245'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=245 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P246'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=246 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P247'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=247 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P248'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=248 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P249'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=249 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P250'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=250 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)

                            ,'P251'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=251 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P252'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=252 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P253'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=253 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P254'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=254 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P255'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=255 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P256'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=256 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P257'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=257 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P258'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=258 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P259'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=259 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P260'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=260 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)

                            ,'P261'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=261 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P262'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=262 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P263'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=263 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P264'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=264 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P265'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=265 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P266'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=266 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P267'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=267 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P268'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=268 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P269'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=269 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P270'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=270 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)

                            ,'P271'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=271 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P272'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=272 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P273'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=273 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P274'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=274 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P275'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=275 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P276'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=276 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P277'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=277 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P278'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=278 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P279'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=279 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P280'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=280 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)

                            ,'P281'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=281 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P282'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=282 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P283'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=283 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P284'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=284 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P285'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=285 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P286'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=286 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P287'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=287 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P288'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=288 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P289'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=289 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P290'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=290 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)

                            ,'P291'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=291 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P292'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=292 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P293'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=293 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P294'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=294 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P295'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=295 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P296'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=296 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P297'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=297 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P298'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=298 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P299'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=299 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)
                            ,'P300'=(SELECT AMOUNT FROM PAY.NEWCALCULATEPAY WHERE DEFINITIONLEGALCAUSE_CON=300 AND LEVFOUR_CON=l.LEVFOUR_CON and fy=l.fy and mounth=L.MOUNTH)

                            ,'bimehBranchName'=(select BranchName from PAY.Branch where BranchID=Branch_con )
                            ,'daraeiBranchName'=(select BranchName from PAY.Branch where BranchID=branch_daraei)
                            ,'costcenter'=lv.NAME
                            ,I.AMEL01,I.AMEL02,I.AMEL03,I.AMEL04,I.AMEL05,I.AMEL06,I.AMEL07,I.AMEL08,I.AMEL09,I.AMEL10,I.AMEL11,I.AMEL12,I.AMEL13,I.AMEL14,I.AMEL15,I.AMEL16,I.AMEL17,I.AMEL18,I.AMEL19,I.AMEL20,I.AMEL21,I.AMEL22,I.AMEL23,I.AMEL24,I.AMEL25,I.AMEL26,I.AMEL27,I.AMEL28,I.AMEL29,I.AMEL30,I.AMEL31,I.AMEL32,I.AMEL33,I.AMEL34,I.AMEL35,I.AMEL36,I.AMEL37,I.AMEL38,I.AMEL39,I.AMEL40,I.AMEL41,I.AMEL42,I.AMEL43,I.AMEL44,I.AMEL45,I.AMEL46,I.AMEL47,I.AMEL48,I.AMEL49,I.AMEL50,I.AMEL51,I.AMEL52,I.AMEL53,I.AMEL54,I.AMEL55,I.AMEL56,I.AMEL57,I.AMEL58,I.AMEL59,I.AMEL60,I.AMEL61,I.AMEL62,I.AMEL63,I.AMEL64,I.AMEL65,I.AMEL66,I.AMEL67,I.AMEL68,I.AMEL69,I.AMEL70,I.AMEL71,I.AMEL72,I.AMEL73,I.AMEL74,I.AMEL75,I.AMEL76,I.AMEL77,I.AMEL78,I.AMEL79,I.AMEL80,I.AMEL81,I.AMEL82,I.AMEL83,I.AMEL84,I.AMEL85,I.AMEL86,I.AMEL87,I.AMEL88,I.AMEL89,I.AMEL90,I.AMEL91,I.AMEL92,I.AMEL93,I.AMEL94,I.AMEL95,I.AMEL96,I.AMEL97,I.AMEL98,I.AMEL99,I.AMEL100,I.AMEL101,I.AMEL102,I.AMEL103,I.AMEL104,I.AMEL105,I.AMEL106,I.AMEL107,I.AMEL108,I.AMEL109
                            ,I.AMEL110,I.AMEL111,I.AMEL112,I.AMEL113,I.AMEL114,I.AMEL115,I.AMEL116,I.AMEL117,I.AMEL118,I.AMEL119,I.AMEL120,I.AMEL121,I.AMEL122,I.AMEL123,I.AMEL124,I.AMEL125,I.AMEL126,I.AMEL127,I.AMEL128
                            ,I.AMEL129,I.AMEL130,I.AMEL131,I.AMEL132,I.AMEL133,I.AMEL134,I.AMEL135,I.AMEL136,I.AMEL137,I.AMEL138,I.AMEL139,I.AMEL140,I.AMEL141,I.AMEL142,I.AMEL143,I.AMEL144,I.AMEL145,I.AMEL146,I.AMEL147,I.AMEL148,I.AMEL149,I.AMEL150

                            from  PAY.NEWCALCULATEPAY L
                            left join cut.LEVFOUR lf on l.LEVFOUR_CON=lf.CUTID
                            join pay.PersonalInfo p on p.levfour_con=L.LEVFOUR_CON
                            join pay.NewOrdinance n on n.PersonalInfo_con=p.PersonalID and n.NewOrdinanceID=L.newordinance_Con
                            left join cut.LEVFOUR lv on n.LEVFOUR_CON=lv.CUTID
                            JOIN pay.informationkarkard i on l.LEVFOUR_CON=i.levfoure_con and i.fy=L.FY and i.mounth=L.MOUNTH
                            WHERE L.FY=@Year AND L.MOUNTH=@Month AND p.PersonalCode=@EmployeeId


                            ";

            using (SqlConnection connection = new SqlConnection(_connectionString))
            {
                using (SqlCommand command = new SqlCommand(query, connection))
                {
                    command.Parameters.AddWithValue("@EmployeeId", employeeId);
                    command.Parameters.AddWithValue("@Year", year);
                    command.Parameters.AddWithValue("@Month", month);

                    await connection.OpenAsync();
                    using (SqlDataReader reader = await command.ExecuteReaderAsync())
                    {
                        if (await reader.ReadAsync())
                        {
                            payslipData = new PayslipDetailDto
                            {



                                کد_تفصیل = Convert.ToString(reader.GetValue(0)),
                                نام_پرسنل = Convert.ToString(reader.GetValue(1)),
                                کد_پرسنلی = Convert.ToString(reader.GetValue(2)),
                                FY = Convert.ToString(reader.GetValue(3)),
                                MOUNTH = Convert.ToString(reader.GetValue(4)),
                                NewOrdinance_CON = Convert.ToString(reader.GetValue(5)),
                                کد_ملی = Convert.ToString(reader.GetValue(6)),
                                محل_صدور = Convert.ToString(reader.GetValue(7)),
                                تاریخ_تولد = Convert.ToString(reader.GetValue(8)),
                                محل_تولد = Convert.ToString(reader.GetValue(9)),
                                نام_پدر = Convert.ToString(reader.GetValue(10)),
                                جنسیت = Convert.ToString(reader.GetValue(11)),
                                شماره_بیمه = Convert.ToString(reader.GetValue(12)),
                                ملیت = Convert.ToString(reader.GetValue(13)),
                                شماره_حساب = Convert.ToString(reader.GetValue(14)),
                                ماه_شمسی = Convert.ToString(reader.GetValue(15)),
                                تاریخ_حکم = Convert.ToString(reader.GetValue(16)),
                                شماره_حکم = Convert.ToString(reader.GetValue(17)),
                                تاریخ_استخدام = Convert.ToString(reader.GetValue(18)),
                                روزهای_کارکرد = Convert.ToString(reader.GetValue(19)),
                                ساعت_اضافه_کاری = Convert.ToString(reader.GetValue(20)),
                                ساعت_تعطیل_کاری = Convert.ToString(reader.GetValue(21)),
                                ساعت_کسر_کار = Convert.ToString(reader.GetValue(22)),
                                تعداد_روز_ماموریت = Convert.ToString(reader.GetValue(23)),
                                ساعت_کارکرد_پرسنل_ساعتی = Convert.ToString(reader.GetValue(24)),
                                تعداد_روز_ایاب_و_ذهاب = Convert.ToString(reader.GetValue(25)),
                                تعداد_روز_غیبت = Convert.ToString(reader.GetValue(26)),
                                تعداد_روز_معوقه = Convert.ToString(reader.GetValue(27)),
                                ساعت_شبکاری = Convert.ToString(reader.GetValue(28)),
                                نوع_حکم = Convert.ToString(reader.GetValue(29)),
                                مرخصی = Convert.ToString(reader.GetValue(30)),
                                مانده_مرخصی = Convert.ToString(reader.GetValue(31)),
                                مبلغ_کل_بازپرداختی_وام = Convert.ToString(reader.GetValue(32)),
                                کل_مبلغ_وام = Convert.ToString(reader.GetValue(33)),
                                مانده_وام = Convert.ToString(reader.GetValue(34)),
                                عیدی_ماهیانه = Convert.ToString(reader.GetValue(35)),
                                سنوات_خدمت_ماهیانه = Convert.ToString(reader.GetValue(36)),
                                EmployeeType_con = Convert.ToString(reader.GetValue(37)),
                                //EmployeeType_con = Convert.ToString(reader.GetValue(reader.GetOrdinal("EmployeeType_con"))),
                                p1 = Convert.ToString(reader.GetValue(38)),
                                p2 = Convert.ToString(reader.GetValue(39)),
                                p3 = Convert.ToString(reader.GetValue(40)),
                                p4 = Convert.ToString(reader.GetValue(41)),
                                p5 = Convert.ToString(reader.GetValue(42)),
                                p6 = Convert.ToString(reader.GetValue(43)),
                                p7 = Convert.ToString(reader.GetValue(44)),
                                p8 = Convert.ToString(reader.GetValue(45)),
                                p9 = Convert.ToString(reader.GetValue(46)),
                                p10 = Convert.ToString(reader.GetValue(47)),
                                p11 = Convert.ToString(reader.GetValue(48)),
                                p12 = Convert.ToString(reader.GetValue(49)),
                                p13 = Convert.ToString(reader.GetValue(50)),
                                p14 = Convert.ToString(reader.GetValue(51)),
                                p15 = Convert.ToString(reader.GetValue(52)),
                                p16 = Convert.ToString(reader.GetValue(53)),
                                p17 = Convert.ToString(reader.GetValue(54)),
                                p18 = Convert.ToString(reader.GetValue(55)),
                                p19 = Convert.ToString(reader.GetValue(56)),
                                p20 = Convert.ToString(reader.GetValue(57)),
                                p21 = Convert.ToString(reader.GetValue(58)),
                                p22 = Convert.ToString(reader.GetValue(59)),
                                p23 = Convert.ToString(reader.GetValue(60)),
                                p24 = Convert.ToString(reader.GetValue(61)),
                                p25 = Convert.ToString(reader.GetValue(62)),
                                p26 = Convert.ToString(reader.GetValue(63)),
                                p27 = Convert.ToString(reader.GetValue(64)),
                                p28 = Convert.ToString(reader.GetValue(65)),
                                p29 = Convert.ToString(reader.GetValue(66)),
                                p30 = Convert.ToString(reader.GetValue(67)),
                                p31 = Convert.ToString(reader.GetValue(68)),
                                p32 = Convert.ToString(reader.GetValue(69)),
                                p33 = Convert.ToString(reader.GetValue(70)),
                                p34 = Convert.ToString(reader.GetValue(71)),
                                p35 = Convert.ToString(reader.GetValue(72)),
                                p36 = Convert.ToString(reader.GetValue(73)),
                                p37 = Convert.ToString(reader.GetValue(74)),
                                p38 = Convert.ToString(reader.GetValue(75)),
                                p39 = Convert.ToString(reader.GetValue(76)),
                                p40 = Convert.ToString(reader.GetValue(77)),
                                p41 = Convert.ToString(reader.GetValue(78)),
                                p42 = Convert.ToString(reader.GetValue(79)),
                                p43 = Convert.ToString(reader.GetValue(80)),
                                p44 = Convert.ToString(reader.GetValue(81)),
                                p45 = Convert.ToString(reader.GetValue(82)),
                                p46 = Convert.ToString(reader.GetValue(83)),
                                p47 = Convert.ToString(reader.GetValue(84)),
                                p48 = Convert.ToString(reader.GetValue(85)),
                                p49 = Convert.ToString(reader.GetValue(86)),
                                p50 = Convert.ToString(reader.GetValue(87)),
                                p51 = Convert.ToString(reader.GetValue(88)),
                                p52 = Convert.ToString(reader.GetValue(89)),
                                p53 = Convert.ToString(reader.GetValue(90)),
                                p54 = Convert.ToString(reader.GetValue(91)),
                                p55 = Convert.ToString(reader.GetValue(92)),
                                p56 = Convert.ToString(reader.GetValue(93)),
                                p57 = Convert.ToString(reader.GetValue(94)),
                                p58 = Convert.ToString(reader.GetValue(95)),
                                p59 = Convert.ToString(reader.GetValue(96)),
                                p60 = Convert.ToString(reader.GetValue(97)),
                                p61 = Convert.ToString(reader.GetValue(98)),
                                p62 = Convert.ToString(reader.GetValue(99)),
                                p63 = Convert.ToString(reader.GetValue(100)),
                                p64 = Convert.ToString(reader.GetValue(101)),
                                p65 = Convert.ToString(reader.GetValue(102)),
                                p66 = Convert.ToString(reader.GetValue(103)),
                                p67 = Convert.ToString(reader.GetValue(104)),
                                p68 = Convert.ToString(reader.GetValue(105)),
                                p69 = Convert.ToString(reader.GetValue(106)),
                                p70 = Convert.ToString(reader.GetValue(107)),
                                p71 = Convert.ToString(reader.GetValue(108)),
                                p72 = Convert.ToString(reader.GetValue(109)),
                                p73 = Convert.ToString(reader.GetValue(110)),
                                p74 = Convert.ToString(reader.GetValue(111)),
                                p75 = Convert.ToString(reader.GetValue(112)),
                                p76 = Convert.ToString(reader.GetValue(113)),
                                p77 = Convert.ToString(reader.GetValue(114)),
                                p78 = Convert.ToString(reader.GetValue(115)),
                                p79 = Convert.ToString(reader.GetValue(116)),
                                p80 = Convert.ToString(reader.GetValue(117)),
                                p81 = Convert.ToString(reader.GetValue(118)),
                                p82 = Convert.ToString(reader.GetValue(119)),
                                p83 = Convert.ToString(reader.GetValue(120)),
                                p84 = Convert.ToString(reader.GetValue(121)),
                                p85 = Convert.ToString(reader.GetValue(122)),
                                p86 = Convert.ToString(reader.GetValue(123)),
                                p87 = Convert.ToString(reader.GetValue(124)),
                                p88 = Convert.ToString(reader.GetValue(125)),
                                p89 = Convert.ToString(reader.GetValue(126)),
                                p90 = Convert.ToString(reader.GetValue(127)),
                                p91 = Convert.ToString(reader.GetValue(128)),
                                p92 = Convert.ToString(reader.GetValue(129)),
                                p93 = Convert.ToString(reader.GetValue(130)),
                                p94 = Convert.ToString(reader.GetValue(131)),
                                p95 = Convert.ToString(reader.GetValue(132)),
                                p96 = Convert.ToString(reader.GetValue(133)),
                                p97 = Convert.ToString(reader.GetValue(134)),
                                p98 = Convert.ToString(reader.GetValue(135)),
                                p99 = Convert.ToString(reader.GetValue(136)),
                                p100 = Convert.ToString(reader.GetValue(137)),

                                p101 = Convert.ToString(reader.GetValue(138)),
                                p102 = Convert.ToString(reader.GetValue(139)),
                                p103 = Convert.ToString(reader.GetValue(140)),
                                p104 = Convert.ToString(reader.GetValue(141)),
                                p105 = Convert.ToString(reader.GetValue(142)),
                                p106 = Convert.ToString(reader.GetValue(143)),
                                p107 = Convert.ToString(reader.GetValue(144)),
                                p108 = Convert.ToString(reader.GetValue(145)),
                                p109 = Convert.ToString(reader.GetValue(146)),
                                p110 = Convert.ToString(reader.GetValue(147)),
                                p111 = Convert.ToString(reader.GetValue(148)),
                                p112 = Convert.ToString(reader.GetValue(149)),
                                p113 = Convert.ToString(reader.GetValue(150)),
                                p114 = Convert.ToString(reader.GetValue(151)),
                                p115 = Convert.ToString(reader.GetValue(152)),
                                p116 = Convert.ToString(reader.GetValue(153)),
                                p117 = Convert.ToString(reader.GetValue(154)),
                                p118 = Convert.ToString(reader.GetValue(155)),
                                p119 = Convert.ToString(reader.GetValue(156)),
                                p120 = Convert.ToString(reader.GetValue(157)),
                                p121 = Convert.ToString(reader.GetValue(158)),
                                p122 = Convert.ToString(reader.GetValue(159)),
                                p123 = Convert.ToString(reader.GetValue(160)),
                                p124 = Convert.ToString(reader.GetValue(161)),
                                p125 = Convert.ToString(reader.GetValue(161)),
                                p126 = Convert.ToString(reader.GetValue(162)),
                                p127 = Convert.ToString(reader.GetValue(163)),
                                p128 = Convert.ToString(reader.GetValue(163)),
                                p129 = Convert.ToString(reader.GetValue(164)),
                                p130 = Convert.ToString(reader.GetValue(165)),
                                p131 = Convert.ToString(reader.GetValue(166)),
                                p132 = Convert.ToString(reader.GetValue(167)),
                                p133 = Convert.ToString(reader.GetValue(168)),
                                p134 = Convert.ToString(reader.GetValue(169)),
                                p135 = Convert.ToString(reader.GetValue(170)),
                                p136 = Convert.ToString(reader.GetValue(171)),
                                p137 = Convert.ToString(reader.GetValue(172)),
                                p138 = Convert.ToString(reader.GetValue(173)),
                                p139 = Convert.ToString(reader.GetValue(174)),
                                p140 = Convert.ToString(reader.GetValue(175)),
                                p141 = Convert.ToString(reader.GetValue(176)),
                                p142 = Convert.ToString(reader.GetValue(177)),
                                p143 = Convert.ToString(reader.GetValue(178)),
                                p144 = Convert.ToString(reader.GetValue(179)),
                                p145 = Convert.ToString(reader.GetValue(180)),
                                p146 = Convert.ToString(reader.GetValue(181)),
                                p147 = Convert.ToString(reader.GetValue(182)),
                                p148 = Convert.ToString(reader.GetValue(183)),
                                p149 = Convert.ToString(reader.GetValue(184)),
                                p150 = Convert.ToString(reader.GetValue(185)),
                                p151 = Convert.ToString(reader.GetValue(186)),
                                p152 = Convert.ToString(reader.GetValue(187)),
                                p153 = Convert.ToString(reader.GetValue(188)),
                                p154 = Convert.ToString(reader.GetValue(189)),
                                p155 = Convert.ToString(reader.GetValue(190)),
                                p156 = Convert.ToString(reader.GetValue(191)),
                                p157 = Convert.ToString(reader.GetValue(192)),
                                p158 = Convert.ToString(reader.GetValue(193)),
                                p159 = Convert.ToString(reader.GetValue(194)),
                                p160 = Convert.ToString(reader.GetValue(195)),
                                p161 = Convert.ToString(reader.GetValue(196)),
                                p162 = Convert.ToString(reader.GetValue(197)),
                                p163 = Convert.ToString(reader.GetValue(198)),
                                p164 = Convert.ToString(reader.GetValue(199)),
                                p165 = Convert.ToString(reader.GetValue(200)),
                                p166 = Convert.ToString(reader.GetValue(201)),
                                p167 = Convert.ToString(reader.GetValue(202)),
                                p168 = Convert.ToString(reader.GetValue(203)),
                                p169 = Convert.ToString(reader.GetValue(204)),
                                p170 = Convert.ToString(reader.GetValue(205)),
                                p171 = Convert.ToString(reader.GetValue(206)),
                                p172 = Convert.ToString(reader.GetValue(207)),
                                p173 = Convert.ToString(reader.GetValue(208)),
                                p174 = Convert.ToString(reader.GetValue(209)),
                                p175 = Convert.ToString(reader.GetValue(210)),
                                p176 = Convert.ToString(reader.GetValue(211)),
                                p177 = Convert.ToString(reader.GetValue(212)),
                                p178 = Convert.ToString(reader.GetValue(213)),
                                p179 = Convert.ToString(reader.GetValue(214)),
                                p180 = Convert.ToString(reader.GetValue(215)),
                                p181 = Convert.ToString(reader.GetValue(216)),
                                p182 = Convert.ToString(reader.GetValue(217)),
                                p183 = Convert.ToString(reader.GetValue(218)),
                                p184 = Convert.ToString(reader.GetValue(219)),
                                p185 = Convert.ToString(reader.GetValue(220)),
                                p186 = Convert.ToString(reader.GetValue(221)),
                                p187 = Convert.ToString(reader.GetValue(222)),
                                p188 = Convert.ToString(reader.GetValue(223)),
                                p189 = Convert.ToString(reader.GetValue(224)),
                                p190 = Convert.ToString(reader.GetValue(225)),
                                p191 = Convert.ToString(reader.GetValue(226)),
                                p192 = Convert.ToString(reader.GetValue(227)),
                                p193 = Convert.ToString(reader.GetValue(228)),
                                p194 = Convert.ToString(reader.GetValue(229)),
                                p195 = Convert.ToString(reader.GetValue(230)),
                                p196 = Convert.ToString(reader.GetValue(231)),
                                p197 = Convert.ToString(reader.GetValue(232)),
                                p198 = Convert.ToString(reader.GetValue(233)),
                                p199 = Convert.ToString(reader.GetValue(234)),
                                p200 = Convert.ToString(reader.GetValue(235)),

                                p201 = Convert.ToString(reader.GetValue(236)),
                                p202 = Convert.ToString(reader.GetValue(237)),
                                p203 = Convert.ToString(reader.GetValue(238)),
                                p204 = Convert.ToString(reader.GetValue(239)),
                                p205 = Convert.ToString(reader.GetValue(240)),
                                p206 = Convert.ToString(reader.GetValue(241)),
                                p207 = Convert.ToString(reader.GetValue(242)),
                                p208 = Convert.ToString(reader.GetValue(243)),
                                p209 = Convert.ToString(reader.GetValue(244)),
                                p210 = Convert.ToString(reader.GetValue(245)),
                                p211 = Convert.ToString(reader.GetValue(246)),
                                p212 = Convert.ToString(reader.GetValue(247)),
                                p213 = Convert.ToString(reader.GetValue(248)),
                                p214 = Convert.ToString(reader.GetValue(249)),
                                p215 = Convert.ToString(reader.GetValue(250)),
                                p216 = Convert.ToString(reader.GetValue(251)),
                                p217 = Convert.ToString(reader.GetValue(252)),
                                p218 = Convert.ToString(reader.GetValue(253)),
                                p219 = Convert.ToString(reader.GetValue(254)),
                                p220 = Convert.ToString(reader.GetValue(255)),
                                p221 = Convert.ToString(reader.GetValue(256)),
                                p222 = Convert.ToString(reader.GetValue(257)),
                                p223 = Convert.ToString(reader.GetValue(258)),
                                p224 = Convert.ToString(reader.GetValue(259)),
                                p225 = Convert.ToString(reader.GetValue(260)),
                                p226 = Convert.ToString(reader.GetValue(261)),
                                p227 = Convert.ToString(reader.GetValue(262)),
                                p228 = Convert.ToString(reader.GetValue(263)),
                                p229 = Convert.ToString(reader.GetValue(264)),
                                p230 = Convert.ToString(reader.GetValue(265)),
                                p231 = Convert.ToString(reader.GetValue(266)),
                                p232 = Convert.ToString(reader.GetValue(267)),
                                p233 = Convert.ToString(reader.GetValue(268)),
                                p234 = Convert.ToString(reader.GetValue(269)),
                                p235 = Convert.ToString(reader.GetValue(270)),
                                p236 = Convert.ToString(reader.GetValue(271)),
                                p237 = Convert.ToString(reader.GetValue(272)),
                                p238 = Convert.ToString(reader.GetValue(273)),
                                p239 = Convert.ToString(reader.GetValue(274)),
                                p240 = Convert.ToString(reader.GetValue(275)),
                                p241 = Convert.ToString(reader.GetValue(276)),
                                p242 = Convert.ToString(reader.GetValue(277)),
                                p243 = Convert.ToString(reader.GetValue(278)),
                                p244 = Convert.ToString(reader.GetValue(279)),
                                p245 = Convert.ToString(reader.GetValue(280)),
                                p246 = Convert.ToString(reader.GetValue(281)),
                                p247 = Convert.ToString(reader.GetValue(282)),

                                p248 = Convert.ToString(reader.GetValue(283)),
                                p249 = Convert.ToString(reader.GetValue(284)),
                                p250 = Convert.ToString(reader.GetValue(285)),
                                p251 = Convert.ToString(reader.GetValue(286)),
                                p252 = Convert.ToString(reader.GetValue(287)),
                                p253 = Convert.ToString(reader.GetValue(288)),
                                p254 = Convert.ToString(reader.GetValue(289)),
                                p255 = Convert.ToString(reader.GetValue(290)),
                                p256 = Convert.ToString(reader.GetValue(291)),
                                p257 = Convert.ToString(reader.GetValue(292)),
                                p258 = Convert.ToString(reader.GetValue(293)),
                                p259 = Convert.ToString(reader.GetValue(294)),
                                p260 = Convert.ToString(reader.GetValue(295)),
                                p261 = Convert.ToString(reader.GetValue(296)),
                                p262 = Convert.ToString(reader.GetValue(297)),
                                p263 = Convert.ToString(reader.GetValue(298)),
                                p264 = Convert.ToString(reader.GetValue(299)),
                                p265 = Convert.ToString(reader.GetValue(300)),
                                p266 = Convert.ToString(reader.GetValue(301)),
                                p267 = Convert.ToString(reader.GetValue(302)),
                                p268 = Convert.ToString(reader.GetValue(303)),
                                p269 = Convert.ToString(reader.GetValue(304)),
                                p270 = Convert.ToString(reader.GetValue(305)),
                                p271 = Convert.ToString(reader.GetValue(306)),
                                p272 = Convert.ToString(reader.GetValue(307)),
                                p273 = Convert.ToString(reader.GetValue(308)),
                                p274 = Convert.ToString(reader.GetValue(309)),
                                p275 = Convert.ToString(reader.GetValue(310)),
                                p276 = Convert.ToString(reader.GetValue(311)),
                                p277 = Convert.ToString(reader.GetValue(312)),
                                p278 = Convert.ToString(reader.GetValue(313)),
                                p279 = Convert.ToString(reader.GetValue(314)),
                                p280 = Convert.ToString(reader.GetValue(315)),
                                p281 = Convert.ToString(reader.GetValue(316)),
                                p282 = Convert.ToString(reader.GetValue(317)),
                                p283 = Convert.ToString(reader.GetValue(318)),
                                p284 = Convert.ToString(reader.GetValue(319)),
                                p285 = Convert.ToString(reader.GetValue(320)),
                                p286 = Convert.ToString(reader.GetValue(321)),
                                p287 = Convert.ToString(reader.GetValue(322)),
                                p288 = Convert.ToString(reader.GetValue(323)),
                                p289 = Convert.ToString(reader.GetValue(324)),
                                p290 = Convert.ToString(reader.GetValue(325)),
                                p291 = Convert.ToString(reader.GetValue(326)),
                                p292 = Convert.ToString(reader.GetValue(327)),
                                p293 = Convert.ToString(reader.GetValue(328)),
                                p294 = Convert.ToString(reader.GetValue(329)),
                                p295 = Convert.ToString(reader.GetValue(330)),
                                p296 = Convert.ToString(reader.GetValue(331)),
                                p297 = Convert.ToString(reader.GetValue(332)),
                                p298 = Convert.ToString(reader.GetValue(333)),
                                p299 = Convert.ToString(reader.GetValue(334)),
                                p300 = Convert.ToString(reader.GetValue(335)),



                                bimehBranchName = Convert.ToString(reader.GetValue(336)),
                                daraeiBranchName = Convert.ToString(reader.GetValue(337)),
                                costcenter = Convert.ToString(reader.GetValue(338)),
                                AMEL01 = Convert.ToString(reader.GetValue(339)),
                                AMEL02 = Convert.ToString(reader.GetValue(340)),
                                AMEL03 = Convert.ToString(reader.GetValue(341)),
                                AMEL04 = Convert.ToString(reader.GetValue(242)),
                                AMEL05 = Convert.ToString(reader.GetValue(243)),
                                AMEL06 = Convert.ToString(reader.GetValue(244)),
                                AMEL07 = Convert.ToString(reader.GetValue(245)),
                                AMEL08 = Convert.ToString(reader.GetValue(246)),
                                AMEL09 = Convert.ToString(reader.GetValue(247)),
                                AMEL10 = Convert.ToString(reader.GetValue(248)),
                                AMEL11 = Convert.ToString(reader.GetValue(249)),
                                AMEL12 = Convert.ToString(reader.GetValue(250)),
                                AMEL13 = Convert.ToString(reader.GetValue(251)),
                                AMEL14 = Convert.ToString(reader.GetValue(252)),
                                AMEL15 = Convert.ToString(reader.GetValue(253)),
                                AMEL16 = Convert.ToString(reader.GetValue(254)),
                                AMEL17 = Convert.ToString(reader.GetValue(255)),
                                AMEL18 = Convert.ToString(reader.GetValue(256)),
                                AMEL19 = Convert.ToString(reader.GetValue(257)),
                                AMEL20 = Convert.ToString(reader.GetValue(258)),
                                AMEL21 = Convert.ToString(reader.GetValue(259)),
                                AMEL22 = Convert.ToString(reader.GetValue(260)),
                                AMEL23 = Convert.ToString(reader.GetValue(261)),
                                AMEL24 = Convert.ToString(reader.GetValue(262)),
                                AMEL25 = Convert.ToString(reader.GetValue(263)),
                                AMEL26 = Convert.ToString(reader.GetValue(264)),
                                AMEL27 = Convert.ToString(reader.GetValue(265)),
                                AMEL28 = Convert.ToString(reader.GetValue(266)),
                                AMEL29 = Convert.ToString(reader.GetValue(267)),
                                AMEL30 = Convert.ToString(reader.GetValue(268)),
                                AMEL31 = Convert.ToString(reader.GetValue(269)),
                                AMEL32 = Convert.ToString(reader.GetValue(270)),
                                AMEL33 = Convert.ToString(reader.GetValue(271)),
                                AMEL34 = Convert.ToString(reader.GetValue(272)),
                                AMEL35 = Convert.ToString(reader.GetValue(273)),
                                AMEL36 = Convert.ToString(reader.GetValue(274)),
                                AMEL37 = Convert.ToString(reader.GetValue(275)),
                                AMEL38 = Convert.ToString(reader.GetValue(276)),
                                AMEL39 = Convert.ToString(reader.GetValue(277)),
                                AMEL40 = Convert.ToString(reader.GetValue(278)),
                                AMEL41 = Convert.ToString(reader.GetValue(279)),
                                AMEL42 = Convert.ToString(reader.GetValue(280)),
                                AMEL43 = Convert.ToString(reader.GetValue(281)),
                                AMEL44 = Convert.ToString(reader.GetValue(282)),
                                AMEL45 = Convert.ToString(reader.GetValue(283)),
                                AMEL46 = Convert.ToString(reader.GetValue(284)),
                                AMEL47 = Convert.ToString(reader.GetValue(285)),
                                AMEL48 = Convert.ToString(reader.GetValue(286)),
                                AMEL49 = Convert.ToString(reader.GetValue(287)),
                                AMEL50 = Convert.ToString(reader.GetValue(288)),
                                AMEL51 = Convert.ToString(reader.GetValue(290)),
                                AMEL52 = Convert.ToString(reader.GetValue(291)),
                                AMEL53 = Convert.ToString(reader.GetValue(292)),
                                AMEL54 = Convert.ToString(reader.GetValue(293)),
                                AMEL55 = Convert.ToString(reader.GetValue(294)),
                                AMEL56 = Convert.ToString(reader.GetValue(295)),
                                AMEL57 = Convert.ToString(reader.GetValue(296)),
                                AMEL58 = Convert.ToString(reader.GetValue(297)),
                                AMEL59 = Convert.ToString(reader.GetValue(298)),
                                AMEL60 = Convert.ToString(reader.GetValue(299)),
                                AMEL61 = Convert.ToString(reader.GetValue(300)),
                                AMEL62 = Convert.ToString(reader.GetValue(301)),
                                AMEL63 = Convert.ToString(reader.GetValue(302)),
                                AMEL64 = Convert.ToString(reader.GetValue(303)),
                                AMEL65 = Convert.ToString(reader.GetValue(304)),
                                AMEL66 = Convert.ToString(reader.GetValue(305)),
                                AMEL67 = Convert.ToString(reader.GetValue(306)),
                                AMEL68 = Convert.ToString(reader.GetValue(307)),
                                AMEL69 = Convert.ToString(reader.GetValue(308)),
                                AMEL70 = Convert.ToString(reader.GetValue(309)),
                                AMEL71 = Convert.ToString(reader.GetValue(310)),
                                AMEL72 = Convert.ToString(reader.GetValue(311)),
                                AMEL73 = Convert.ToString(reader.GetValue(312)),
                                AMEL74 = Convert.ToString(reader.GetValue(313)),
                                AMEL75 = Convert.ToString(reader.GetValue(314)),
                                AMEL76 = Convert.ToString(reader.GetValue(315)),
                                AMEL77 = Convert.ToString(reader.GetValue(316)),
                                AMEL78 = Convert.ToString(reader.GetValue(317)),
                                AMEL79 = Convert.ToString(reader.GetValue(318)),
                                AMEL80 = Convert.ToString(reader.GetValue(319)),
                                AMEL81 = Convert.ToString(reader.GetValue(320)),
                                AMEL82 = Convert.ToString(reader.GetValue(321)),
                                AMEL83 = Convert.ToString(reader.GetValue(322)),
                                AMEL84 = Convert.ToString(reader.GetValue(323)),
                                AMEL85 = Convert.ToString(reader.GetValue(324)),
                                AMEL86 = Convert.ToString(reader.GetValue(325)),
                                AMEL87 = Convert.ToString(reader.GetValue(326)),
                                AMEL88 = Convert.ToString(reader.GetValue(327)),
                                AMEL89 = Convert.ToString(reader.GetValue(328)),
                                AMEL90 = Convert.ToString(reader.GetValue(329)),
                                AMEL91 = Convert.ToString(reader.GetValue(330)),
                                AMEL92 = Convert.ToString(reader.GetValue(331)),
                                AMEL93 = Convert.ToString(reader.GetValue(332)),
                                AMEL94 = Convert.ToString(reader.GetValue(333)),
                                AMEL95 = Convert.ToString(reader.GetValue(334)),
                                AMEL96 = Convert.ToString(reader.GetValue(335)),
                                AMEL98 = Convert.ToString(reader.GetValue(335)),
                                AMEL99 = Convert.ToString(reader.GetValue(335)),
                                AMEL100 = Convert.ToString(reader.GetValue(335)),
                                AMEL101 = Convert.ToString(reader.GetValue(335)),
                                AMEL102 = Convert.ToString(reader.GetValue(335)),
                                AMEL103 = Convert.ToString(reader.GetValue(335)),
                                AMEL104 = Convert.ToString(reader.GetValue(335)),
                                AMEL105 = Convert.ToString(reader.GetValue(335)),
                                AMEL106 = Convert.ToString(reader.GetValue(335)),
                                AMEL107 = Convert.ToString(reader.GetValue(335)),
                                AMEL108 = Convert.ToString(reader.GetValue(335)),
                                AMEL109 = Convert.ToString(reader.GetValue(335)),
                                AMEL110 = Convert.ToString(reader.GetValue(335)),
                                AMEL111 = Convert.ToString(reader.GetValue(335)),
                                AMEL112 = Convert.ToString(reader.GetValue(335)),
                                AMEL113 = Convert.ToString(reader.GetValue(335)),
                                AMEL114 = Convert.ToString(reader.GetValue(335)),
                                AMEL115 = Convert.ToString(reader.GetValue(335)),
                                AMEL116 = Convert.ToString(reader.GetValue(335)),
                                AMEL117 = Convert.ToString(reader.GetValue(335)),
                                AMEL118 = Convert.ToString(reader.GetValue(335)),
                                AMEL119 = Convert.ToString(reader.GetValue(335)),
                                AMEL120 = Convert.ToString(reader.GetValue(335)),
                                AMEL121 = Convert.ToString(reader.GetValue(335)),
                                AMEL122 = Convert.ToString(reader.GetValue(335)),
                                AMEL123 = Convert.ToString(reader.GetValue(335)),
                                AMEL124 = Convert.ToString(reader.GetValue(335)),
                                AMEL125 = Convert.ToString(reader.GetValue(335)),
                                AMEL126 = Convert.ToString(reader.GetValue(335)),
                                AMEL127 = Convert.ToString(reader.GetValue(335)),
                                AMEL128 = Convert.ToString(reader.GetValue(335)),
                                AMEL129 = Convert.ToString(reader.GetValue(335)),
                                AMEL130 = Convert.ToString(reader.GetValue(335)),
                                AMEL131 = Convert.ToString(reader.GetValue(335)),
                                AMEL132 = Convert.ToString(reader.GetValue(335)),
                                AMEL133 = Convert.ToString(reader.GetValue(335)),
                                AMEL134 = Convert.ToString(reader.GetValue(335)),
                                AMEL135 = Convert.ToString(reader.GetValue(335)),
                                AMEL136 = Convert.ToString(reader.GetValue(335)),
                                AMEL137 = Convert.ToString(reader.GetValue(335)),
                                AMEL138 = Convert.ToString(reader.GetValue(335)),
                                AMEL139 = Convert.ToString(reader.GetValue(335)),
                                AMEL140 = Convert.ToString(reader.GetValue(335)),
                                AMEL141 = Convert.ToString(reader.GetValue(335)),
                                AMEL142 = Convert.ToString(reader.GetValue(335)),
                                AMEL143 = Convert.ToString(reader.GetValue(335)),
                                AMEL144 = Convert.ToString(reader.GetValue(335)),
                                AMEL145 = Convert.ToString(reader.GetValue(335)),
                                AMEL146 = Convert.ToString(reader.GetValue(335)),
                                AMEL147 = Convert.ToString(reader.GetValue(335)),
                                AMEL148 = Convert.ToString(reader.GetValue(335)),
                                AMEL149 = Convert.ToString(reader.GetValue(335)),
                                AMEL150 = Convert.ToString(reader.GetValue(335)),

                            };
                        }
                    }
                }
            }

            if (payslipData == null)
            {
                return NotFound();
            }

            return payslipData;
        }
    }
}
