import { Component } from '@angular/core';
import { Router } from '@angular/router';

@Component({
  selector: 'app-root',
  templateUrl: './app.component.html',
  styleUrls: ['./app.component.scss']
})
export class AppComponent {
  employeeId: string = '';
  month: string = '';
  year: string = '';

  constructor(private router: Router) {}

  goToPayslip() {
    console.log(this.employeeId, this.month, this.year);
    if (this.employeeId && this.month && this.year) {
      this.router.navigate(
        ['/payslip', this.employeeId],
        { queryParams: { month: this.month, year: this.year } }
      );
    }
  }
}
