import { Component } from '@angular/core';
import { Router } from '@angular/router';

@Component({
  selector: 'app-login',
  templateUrl: './login.component.html',
  styleUrls: ['./login.component.scss']
})
export class LoginComponent {
  employeeId: string = '';
  month: string = '';
  year: string = '';

  constructor(private router: Router) {}

  goToPayslip() {
    if (this.employeeId && this.month && this.year) {
      this.router.navigate(['/payslip', this.employeeId], {
        queryParams: { month: this.month, year: this.year }
      });
    }
  }
}
