import { Component, OnInit } from '@angular/core';
import { ActivatedRoute } from '@angular/router';
import { PayslipDetail } from 'src/app/Models/PayslipDetail';
import { PayslipService } from 'src/app/servise/payslip-service.service';

@Component({
  selector: 'app-payslip-lis',
  templateUrl: './payslip-lis.component.html',
  styleUrls: ['./payslip-lis.component.scss']
})
export class PayslipLisComponent implements OnInit {

  payslips: PayslipDetail |undefined;
  isLoading = false;
  errorMessage: string | null = null;
  employeeId: string| null = null;
  month: string | null = null;
  year: string| null = null;

  constructor(private payslipService: PayslipService,private route: ActivatedRoute) { }

  ngOnInit(): void {
    this.route.paramMap.subscribe(params => {
      this.employeeId = params.get('employeeId');
      console.log('Employee ID:', this.employeeId);

      // فراخوانی queryParamMap داخل همین subscribe یا به صورت جداگانه
      this.route.queryParamMap.subscribe(queryParams => {
        this.month = queryParams.get('month'); // 👈 با + به عدد تبدیل می‌کنیم. اگر وجود نداشته باشد، 0 یا NaN می‌شود.
        this.year = queryParams.get('year');   // 👈 اگر وجود نداشته باشد، 0 یا NaN می‌شود.
        console.log('Month:', this.month);
        console.log('Year:', this.year);
        if (this.employeeId && this.month && this.year) {        // اینجا می‌توانید با استفاده از employeeId, month, و year، فیش‌های حقوقی را فراخوانی کنید.
        this.loadPayslips(this.employeeId, this.year, this.month);
        }
      });
    });
    //this.loadPayslips('12345', '1403', '05'); // مثال: فراخوانی با مقادیر نمونه
  }

  loadPayslips(employeeId: string, year: string, month: string): void {
    this.isLoading = true;
    this.errorMessage = null;
    this.payslipService.getEmployeePayslipDetails(employeeId, year, month).subscribe({
      next: (data) => {
        this.payslips = data;
        this.isLoading = false;
        console.log('payslips:', this.payslips);
        
  

       
      },
      error: (error) => {
        this.errorMessage = 'خطا در دریافت اطلاعات فیش حقوقی: ' + error.message;
        this.isLoading = false;
        console.error('Error loading payslips:', error);
      }
    });
  }
}


