// src/app/services/payslip.service.ts

import { Injectable } from '@angular/core';
import { HttpClient } from '@angular/common/http';
import { Observable } from 'rxjs';
import { PayslipDetail } from '../Models/PayslipDetail'; // ایمپورت کردن مدل
import { environment } from '../../environments/environment';

@Injectable({
  providedIn: 'root'
})
export class PayslipService {
  //private apiUrl = 'YOUR_API_BASE_URL/api/payslips'; // آدرس API شما
  private apiUrl = `${environment.apiUrl}/api/Payslips`;

  constructor(private http: HttpClient) { }

  getEmployeePayslipDetails(employeeId: string, year: string, month: string): Observable<PayslipDetail> {
    // فرض کنید API شما یک آرایه از PayslipDetail برمی‌گردونه
    return this.http.get<PayslipDetail>(`${this.apiUrl}/employee?employeeId=${employeeId}&year=${year}&month=${month}`);
  }

  
}
